/*
 * Decompiled with CFR 0.152.
 */
package com.work4games.entity;

import com.work4games.entity.Object;
import com.work4games.handlers.Content;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;

public class Gem
extends Object {
    private BufferedImage sprite;
    private int gemType;
    private boolean wait = false;
    private boolean selected = false;
    private boolean swap = false;
    private int tempx;
    private int tempy;
    private double dx = 4.0;
    private double dy = 4.0;
    private int row;
    private int col;
    public static final int NUMOFGEMS = 6;
    public static final int SAPPHIRE = 0;
    public static final int RUBY = 1;
    public static final int EMERALD = 2;
    public static final int DIAMOND = 3;
    public static final int AMBER = 4;
    public static final int AMETHYST = 5;

    public Gem(int x, int y, int row, int col) {
        this.ID = 0;
        this.row = row;
        this.col = col;
        int randomInt = (int)(Math.random() * 6.0 + 1.0);
        switch (randomInt) {
            case 1: {
                this.sprite = Content.Sapphire;
                this.gemType = 0;
                break;
            }
            case 2: {
                this.sprite = Content.Ruby;
                this.gemType = 1;
                break;
            }
            case 3: {
                this.sprite = Content.Emerald;
                this.gemType = 2;
                break;
            }
            case 4: {
                this.sprite = Content.Diamond;
                this.gemType = 3;
                break;
            }
            case 5: {
                this.sprite = Content.Amber;
                this.gemType = 4;
                break;
            }
            case 6: {
                this.sprite = Content.Amethyst;
                this.gemType = 5;
            }
        }
        this.cwidth = 32;
        this.width = 32;
        this.cheight = 32;
        this.height = 32;
        this.x = x;
        this.y = y;
    }

    public void update() {
        if (this.swap) {
            int diry;
            this.swap = false;
            int dirx = this.tempx - this.x;
            if (dirx != 0) {
                this.swap = true;
                this.x = dirx > 0 ? (int)((double)this.x + this.dx) : (int)((double)this.x - this.dx);
                if ((this.tempx - this.x) % 40 == 0) {
                    this.wait = false;
                }
            }
            if ((diry = this.tempy - this.y) != 0) {
                this.swap = true;
                this.y = diry > 0 ? (int)((double)this.y + this.dy) : (int)((double)this.y - this.dy);
                if ((this.tempy - this.y) % 40 == 0) {
                    this.wait = false;
                }
            }
        }
    }

    @Override
    public void draw(Graphics2D g) {
        g.drawImage((Image)this.sprite, this.x, this.y, null);
        g.setColor(Color.YELLOW);
        if (this.selected) {
            g.drawRect(this.x - 2, this.y - 2, this.width + 4, this.height + 4);
        }
    }

    public void swap(Gem g) {
        this.swap = true;
        g.setSwap(true);
        int temprow = this.row;
        int tempcol = this.col;
        this.tempx = g.getx();
        this.tempy = g.gety();
        this.row = g.getRow();
        this.col = g.getCol();
        g.setTempPosition(this.x, this.y);
        g.setRow(temprow);
        g.setCol(tempcol);
    }

    public void swap(int tempx, int tempy, int row, int col) {
        this.swap = true;
        this.wait = true;
        this.tempx = tempx;
        this.tempy = tempy;
        this.row = row;
        this.col = col;
    }

    public int getGemType() {
        return this.gemType;
    }

    public boolean getWait() {
        return this.wait;
    }

    public void setGemType(int type) {
        switch (type) {
            case 0: {
                this.sprite = Content.Sapphire;
                this.gemType = 0;
                break;
            }
            case 1: {
                this.sprite = Content.Ruby;
                this.gemType = 1;
                break;
            }
            case 2: {
                this.sprite = Content.Emerald;
                this.gemType = 2;
                break;
            }
            case 3: {
                this.sprite = Content.Diamond;
                this.gemType = 3;
                break;
            }
            case 4: {
                this.sprite = Content.Amber;
                this.gemType = 4;
                break;
            }
            case 5: {
                this.sprite = Content.Amethyst;
                this.gemType = 5;
            }
        }
    }

    public boolean getSelected() {
        return this.selected;
    }

    public void setSelected(boolean b) {
        this.selected = b;
    }

    public int getRow() {
        return this.row;
    }

    public void setRow(int r) {
        this.row = r;
    }

    public int getCol() {
        return this.col;
    }

    public void setCol(int c) {
        this.col = c;
    }

    public boolean getSwap() {
        return this.swap;
    }

    public void setSwap(boolean b) {
        this.swap = b;
    }

    public void setTempPosition(int x, int y) {
        this.tempx = x;
        this.tempy = y;
    }
}

